//=============================================================================
// Balloon subclass for Clay balloons, never spawned (on purpose lol!!)
//=============================================================================
class Balloon_Clay extends Balloon;

/* clay balloons group contains the following balloons:
	- red 		(layers: 10, speed: 1.300000, key: K)
	- blue		(layers: 15, speed: 1.400000, key: L)
	- green		(layers: 20, speed: 1.500000, key: M)
	- Yellow	(layers: 25, speed: 1.600000, key: N)
*/

#exec obj load file=..\Textures\PopBalloonsTextures.utx package=PopBalloonsTextures
#exec mesh import mesh=ClayBalloon anivfile=Models\ClayBalloon_a.3d datafile=Models\ClayBalloon_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=ClayBalloon x=0 y=0 z=0
#exec mesh sequence mesh=ClayBalloon seq=All startframe=0 numframes=1
#exec meshmap new meshmap=ClayBalloon mesh=ClayBalloon
#exec meshmap scale meshmap=ClayBalloon x=0.12085 y=0.12085 z=0.24170

function SetColor()
{
	if ( Health <= 10 )
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cClayRed';
		AirSpeed = BaseSpeed * 1.300000;
		DrawScale = Default.DrawScale * 0.9 * 0.9 * 0.9;
		}
	else if ( Health <= 15 )
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cClayBlue';
		AirSpeed = BaseSpeed * 1.400000;
		DrawScale = Default.DrawScale * 0.9 * 0.9;
		}
	else if ( Health <= 20 )
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cClayGreen';
		AirSpeed = BaseSpeed * 1.500000;
		DrawScale = Default.DrawScale * 0.9;
		}
	else
		{
		MultiSkins[0] = Texture'PopBalloonsTextures.Colors.cClayYellow';
		AirSpeed = BaseSpeed * 1.600000;
		}
}

defaultproperties
{
	 layers=1
	 speed=1.000000
     AmbientGlow=64
	 DrawType=DT_Mesh
	 Mesh=Mesh'ClayBalloon'
	 CollisionRadius=16.00000
	 CollisionHeight=30.93823
	 DrawScale=0.5
}
